unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, jpeg, PixTwixLib_TLB;

const
  MSG_LOUPE = 'Click anywhere on image to see LOUPE effect';
  FX_LOUPE = 0 ;
  MSG_TWIRL = 'Click anywhere on image to see TWIRL effect';
  FX_TWIRL = 1;
  MSG_ZOOM = 'Left click to zoom in, right click to zoom out';
  FX_ZOOM = 2;
  MSG_MAGICWAND = 'Click anywhere inside area you want to select';
  FX_MAGICWAND = 3;


type
  TForm1 = class(TForm)
    Display: TImage;
    btnUndo: TButton;
    btnReload: TButton;
    MainMenu1: TMainMenu;
    dlgColor: TColorDialog;
    Attributes1: TMenuItem;
    Border1: TMenuItem;
    Color1: TMenuItem;
    Flipetc1: TMenuItem;
    Rotation1: TMenuItem;
    Security1: TMenuItem;
    Size1: TMenuItem;
    Sharpness1: TMenuItem;
    SpecialFX1: TMenuItem;
    Selections1: TMenuItem;
    Zoom1: TMenuItem;
    Brightness1: TMenuItem;
    Contrast1: TMenuItem;
    Saturation1: TMenuItem;
    Erodeborder1: TMenuItem;
    Drawframe1: TMenuItem;
    Paintoncanvas1: TMenuItem;
    Blackandwhite1: TMenuItem;
    Blackandwhitedithered1: TMenuItem;
    Colorize1: TMenuItem;
    Grayscale1: TMenuItem;
    Posterize1: TMenuItem;
    Tint1: TMenuItem;
    Flip1: TMenuItem;
    Reverse1: TMenuItem;
    Reflectleft1: TMenuItem;
    Reflectright1: TMenuItem;
    Reflecttop1: TMenuItem;
    Reflectbottom1: TMenuItem;
    Rotate90degrees1: TMenuItem;
    Rotate180degrees1: TMenuItem;
    Rotate270degrees1: TMenuItem;
    Rotatewithclipping1: TMenuItem;
    Rotatewithoutclipping1: TMenuItem;
    Encrypt1: TMenuItem;
    Decrypt1: TMenuItem;
    Cropandresize1: TMenuItem;
    Antialias1: TMenuItem;
    Blur1: TMenuItem;
    Soften1: TMenuItem;
    Enhanceedge1: TMenuItem;
    Sharpen1: TMenuItem;
    Addnoise1: TMenuItem;
    Blend1: TMenuItem;
    Emboss1: TMenuItem;
    Loupe1: TMenuItem;
    Mosaic1: TMenuItem;
    Scramble1: TMenuItem;
    Solarize1: TMenuItem;
    Spray1: TMenuItem;
    Texture1: TMenuItem;
    Tile1: TMenuItem;
    Twirl1: TMenuItem;
    Staggerrows1: TMenuItem;
    Staggercolumns1: TMenuItem;
    Selectirregularregionandinvertselected1: TMenuItem;
    Selectirregularregionandapplytexturetoselection1: TMenuItem;
    Selectusingglobalmagicwandandmasknotselected1: TMenuItem;
    Freezoom1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure btnReloadClick(Sender: TObject);
    procedure btnUndoClick(Sender: TObject);
    procedure DisplayMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Brightness1Click(Sender: TObject);
    procedure Contrast1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Saturation1Click(Sender: TObject);
    procedure Erodeborder1Click(Sender: TObject);
    procedure Drawframe1Click(Sender: TObject);
    procedure Paintoncanvas1Click(Sender: TObject);
    procedure Blackandwhite1Click(Sender: TObject);
    procedure Blackandwhitedithered1Click(Sender: TObject);
    procedure Colorize1Click(Sender: TObject);
    procedure Grayscale1Click(Sender: TObject);
    procedure Posterize1Click(Sender: TObject);
    procedure Tint1Click(Sender: TObject);
    procedure Flip1Click(Sender: TObject);
    procedure Reverse1Click(Sender: TObject);
    procedure Reflectleft1Click(Sender: TObject);
    procedure Reflectright1Click(Sender: TObject);
    procedure Reflecttop1Click(Sender: TObject);
    procedure Reflectbottom1Click(Sender: TObject);
    procedure Rotate90degrees1Click(Sender: TObject);
    procedure Rotate180degrees1Click(Sender: TObject);
    procedure Rotate270degrees1Click(Sender: TObject);
    procedure Rotatewithclipping1Click(Sender: TObject);
    procedure Rotatewithoutclipping1Click(Sender: TObject);
    procedure Encrypt1Click(Sender: TObject);
    procedure Decrypt1Click(Sender: TObject);
    procedure Cropandresize1Click(Sender: TObject);
    procedure Antialias1Click(Sender: TObject);
    procedure Blur1Click(Sender: TObject);
    procedure Soften1Click(Sender: TObject);
    procedure Enhanceedge1Click(Sender: TObject);
    procedure Sharpen1Click(Sender: TObject);
    procedure Addnoise1Click(Sender: TObject);
    procedure Blend1Click(Sender: TObject);
    procedure Emboss1Click(Sender: TObject);
    procedure Loupe1Click(Sender: TObject);
    procedure Mosaic1Click(Sender: TObject);
    procedure Scramble1Click(Sender: TObject);
    procedure Solarize1Click(Sender: TObject);
    procedure Spray1Click(Sender: TObject);
    procedure Texture1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Twirl1Click(Sender: TObject);
    procedure Staggerrows1Click(Sender: TObject);
    procedure Staggercolumns1Click(Sender: TObject);
    procedure Selectirregularregionandinvertselected1Click(
      Sender: TObject);
    procedure Selectirregularregionandapplytexturetoselection1Click(
      Sender: TObject);
    procedure Selectusingglobalmagicwandandmasknotselected1Click(
      Sender: TObject);
    procedure Freezoom1Click(Sender: TObject);
  private
    undo_file     : String;
    magnification : Integer;
    zoomed_left   : Integer;
    zoomed_top    : Integer;
    effect        : Integer;
    path          : String;
    procedure Prepare;
    procedure UpdateDisplay;
    procedure ShowMsg;
  public
    PixTwix : TPixTwix;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  PixTwix := TPixTwix.Create (nil);
  PixTwix.Unlock('your registration code here');
  self.Caption := 'PixTwix ' + PixTwix.GetVersion + ' demo project';
  path := IncludeTrailingBackslash(ExtractFilePath(ParamStr(0)));
  btnUndo.Enabled := False;
  Display.Picture.LoadFromFile (path + 'kids.jpg');
  undo_file := path + 'undo.bmp';
  effect := -1;
  magnification := 1;
  zoomed_left := 0;
  zoomed_top := 0;
  ShowMsg;
end;

procedure TForm1.Prepare;
var
  tmp : TBitmap;
begin
  tmp := TBitmap.Create ;
  try
    tmp.Width := Display.Picture.Width ;
    tmp.Height := Display.Picture.Height ;
    tmp.Canvas.Draw (0, 0, Display.Picture.Graphic);
    PixTwix.SetPictureHandle (tmp.Handle);
    if PixTwix.UndoSave(undo_file) then btnUndo.Enabled := True
    else btnUndo.Enabled := False;
  finally
    tmp.Free ;
  end;
end;

procedure TForm1.ShowMsg;
var
  msg : TStringList;
begin
  msg := TStringList.Create ;
  try
    msg.LoadFromFile (path + 'demo.txt');
    ShowMessage(msg.Text);
  finally
    msg.Free ;
  end;
end;

procedure TForm1.UpdateDisplay;
begin
  Display.Picture.Bitmap.Handle := PixTwix.GetPictureHandle ;
end;

procedure TForm1.btnReloadClick(Sender: TObject);
begin
  Display.Picture.LoadFromFile (path + 'kids.jpg');
  effect := -1;
  magnification := 1;
  zoomed_left := 0;
  zoomed_top := 0;
end;

procedure TForm1.btnUndoClick(Sender: TObject);
begin
  if PixTwix.UndoLoad(undo_file) then
    begin
    UpdateDisplay;
    btnUndo.Enabled := False;
    end;
end;

procedure TForm1.DisplayMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  cx, cy : Integer;
begin

  case effect of

  FX_LOUPE:
    begin
    Prepare;
    if PixTwix.Loupe(X, Y, 120, 60) then UpdateDisplay;
    end;

  FX_TWIRL:
    begin
    Prepare;
    if PixTwix.Twirl(X, Y, 120) then UpdateDisplay;
    end;
      
  FX_ZOOM:
    begin
      cx := zoomed_left + X div magnification;
      cy := zoomed_top + Y div magnification;
      if Button = mbLeft then magnification := magnification * 2
      else if Button = mbRight then magnification := magnification div 2;
      if magnification < 1 then magnification := 1;
      if PixTwix.Zoom(cx, cy, magnification) then
        Display.Picture.Bitmap.Handle := PixTwix.GetSecondaryPictureHandle ;
      zoomed_left := PixTwix.GetZoomedLeft;
      zoomed_top := PixTwix.GetZoomedTop;
    end;

  FX_MAGICWAND:
    begin
    PixTwix.SelectNone;
    PixTwix.SelectUsingGlobalMagicWand (X, Y, 15, mwRGB);
    if PixTwix.MaskNotSelected(0, 0, 0) then UpdateDisplay;
    end;

  end ;
end;

procedure TForm1.Brightness1Click(Sender: TObject);
begin
  Prepare;
  if PixTwix.Brightness(20, False) then UpdateDisplay;
end;

procedure TForm1.Contrast1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Contrast(30, False) Then UpdateDisplay;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  PixTwix.Free ;
end;

procedure TForm1.Saturation1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Saturation(20, False) Then UpdateDisplay;
end;

procedure TForm1.Erodeborder1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.ErodeBorder(20, 255, 255, 255) Then UpdateDisplay;
end;

procedure TForm1.Drawframe1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Frame(16, 50, 50, 250, 220, 220, 220) Then UpdateDisplay;
end;

procedure TForm1.Paintoncanvas1Click(Sender: TObject);
var
  w, h : Integer;
begin
  Prepare;
  w := PixTwix.GetPictureWidth;
  h := PixTwix.GetPictureHeight;
  If PixTwix.PaintOnCanvas(w + 50, h + 50, 25, 25, 255, 255, 255, 10, 10, 6, 128, 128, 128) Then UpdateDisplay;
end;

procedure TForm1.Blackandwhite1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.BlackAndWhite(127, False) Then UpdateDisplay;
end;

procedure TForm1.Blackandwhitedithered1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.BlackAndWhiteDithered(0, False) Then UpdateDisplay;
end;

procedure TForm1.Colorize1Click(Sender: TObject);
var
  R, G, B: Integer;
begin
  if not dlgColor.Execute then exit;
  R := PixTwix.GetRed(dlgColor.Color);
  G := PixTwix.GetGreen(dlgColor.Color);
  B := PixTwix.GetBlue(dlgColor.Color);
  Prepare;
  If PixTwix.Colorize(R, G, B, False) Then UpdateDisplay;
end;

procedure TForm1.Grayscale1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Grayscale(gsWeighted, False) Then UpdateDisplay;
end;

procedure TForm1.Posterize1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Posterize(3, 3, 3, False) Then UpdateDisplay;
end;

procedure TForm1.Tint1Click(Sender: TObject);
var
  R, G, B: Integer;
begin
  if not dlgColor.Execute then exit;
  R := PixTwix.GetRed(dlgColor.Color);
  G := PixTwix.GetGreen(dlgColor.Color);
  B := PixTwix.GetBlue(dlgColor.Color);
  Prepare;
  If PixTwix.Tint(R, G, B, False) Then UpdateDisplay;
end;

procedure TForm1.Flip1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Flip Then UpdateDisplay;
end;

procedure TForm1.Reverse1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Reverse Then UpdateDisplay;
end;

procedure TForm1.Reflectleft1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Reflect(rmLeft) Then UpdateDisplay;
end;

procedure TForm1.Reflectright1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Reflect(rmRight) Then UpdateDisplay;
end;

procedure TForm1.Reflecttop1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Reflect(rmTop) Then UpdateDisplay;
end;

procedure TForm1.Reflectbottom1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Reflect(rmBottom) Then UpdateDisplay;
end;

procedure TForm1.Rotate90degrees1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Rotate90 Then UpdateDisplay;
end;

procedure TForm1.Rotate180degrees1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Rotate180 Then UpdateDisplay;
end;

procedure TForm1.Rotate270degrees1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Rotate270 Then UpdateDisplay;
end;

procedure TForm1.Rotatewithclipping1Click(Sender: TObject);
var
  cx, cy : Integer;
begin
  Prepare;
  cx := PixTwix.GetPictureWidth div 2;
  cy := PixTwix.GetPictureHeight div 2;
  If PixTwix.RotatePicture(cx, cy, 45, 255, 255, 255) Then UpdateDisplay;
end;

procedure TForm1.Rotatewithoutclipping1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.RotatePictureEx(45, 255, 255, 255) Then UpdateDisplay;
end;

procedure TForm1.Encrypt1Click(Sender: TObject);
var
  password : String;
begin
  Prepare;
  password := InputBox('Image encryption', 'Password', '');
  If PixTwix.Encrypt(password) Then UpdateDisplay;
end;

procedure TForm1.Decrypt1Click(Sender: TObject);
var
  password : String;
begin
  Prepare;
  password := InputBox('Image encryption', 'Password', '');
  If PixTwix.Decrypt (password) Then UpdateDisplay;
end;

procedure TForm1.Cropandresize1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.CropPicture(0, 0, 400, 300) Then
    If PixTwix.ResizePicture(640, 480, True) Then UpdateDisplay;
end;

procedure TForm1.Antialias1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Antialias(False) Then UpdateDisplay;
end;

procedure TForm1.Blur1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.BlurMore(False) Then UpdateDisplay;
end;

procedure TForm1.Soften1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.SoftenMore(False) Then UpdateDisplay;
end;

procedure TForm1.Enhanceedge1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.EnhanceEdge(False) Then UpdateDisplay;
end;

procedure TForm1.Sharpen1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Sharpen(False) Then UpdateDisplay;
end;

procedure TForm1.Addnoise1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.AddNoise(50, True, False) Then UpdateDisplay;
end;

procedure TForm1.Blend1Click(Sender: TObject);
var
  bmp : TBitmap;
  pic : TPicture;
begin
  Prepare;
  pic := TPicture.Create ;
  pic.LoadFromFile (path + 'sunset.jpg');
  bmp := TBitmap.Create ;
  try
    bmp.Width := pic.Width ;
    bmp.Height := pic.Height ;
    bmp.Canvas.Draw (0, 0, pic.Graphic);
    PixTwix.SetSecondaryPictureHandle (bmp.Handle);
  finally
    pic.Free ;
    bmp.Free ;
  end;
  If PixTwix.Blend(50, 50, False) Then UpdateDisplay;
end;

procedure TForm1.Emboss1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Emboss(edNorthEast, 3, 127, False) Then UpdateDisplay;
end;

procedure TForm1.Loupe1Click(Sender: TObject);
begin
  ShowMessage(MSG_LOUPE);
  effect := FX_LOUPE;
end;

procedure TForm1.Mosaic1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Mosaic(10, 10, False) Then UpdateDisplay;
end;

procedure TForm1.Scramble1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Scramble(100, 75) Then UpdateDisplay;
end;

procedure TForm1.Solarize1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Solarize(80, 80, 80, True, False) Then UpdateDisplay;
end;

procedure TForm1.Spray1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.Spray(20, False) Then UpdateDisplay;
end;

procedure TForm1.Texture1Click(Sender: TObject);
var
  bmp : TBitmap;
  pic : TPicture;
begin
  Prepare;
  pic := TPicture.Create ;
  pic.LoadFromFile (path + 'texture.jpg');
  bmp := TBitmap.Create ;
  try
    bmp.Width := pic.Width ;
    bmp.Height := pic.Height ;
    bmp.Canvas.Draw (0, 0, pic.Graphic);
    PixTwix.SetSecondaryPictureHandle (bmp.Handle);
  finally
    pic.Free ;
    bmp.Free ;
  end;

  If PixTwix.Texture(0, tmStretched, False) Then UpdateDisplay;

end;

procedure TForm1.Tile1Click(Sender: TObject);
begin
  Prepare;
  If PixTwix.TileEx(100, 75) Then UpdateDisplay;
end;

procedure TForm1.Twirl1Click(Sender: TObject);
begin
  ShowMessage(MSG_TWIRL);
  effect := FX_TWIRL;
end;

procedure TForm1.Staggerrows1Click(Sender: TObject);
var
  i : Integer;
begin
  Prepare;
  For i := 1 To 5 do PixTwix.StaggerRows (True);
  UpdateDisplay;
end;

procedure TForm1.Staggercolumns1Click(Sender: TObject);
var
  i : Integer;
begin
  Prepare;
  For i := 1 To 5 do PixTwix.StaggerColumns (True);
  UpdateDisplay;
end;

procedure TForm1.Selectirregularregionandinvertselected1Click(
  Sender: TObject);
begin
  Display.Picture.LoadFromFile (path + 'kids.jpg');
  Prepare;
  PixTwix.SelectNone;
  PixTwix.SelectEllipse (10, 10, 250, 200);
  PixTwix.SelectEllipse (400, 70, 635, 500);
  If PixTwix.Negative(True, True, True, True) Then UpdateDisplay;
end;

procedure TForm1.Selectirregularregionandapplytexturetoselection1Click(
  Sender: TObject);
var
  bmp : TBitmap;
  pic : TPicture;
begin
  Display.Picture.LoadFromFile (path + 'kids.jpg');
  Prepare;
  PixTwix.SelectNone;
  PixTwix.SelectEllipse (10, 10, 250, 200);
  PixTwix.SelectEllipse (400, 70, 635, 500);
  pic := TPicture.Create ;
  pic.LoadFromFile (path + 'texture.jpg');
  bmp := TBitmap.Create ;
  try
    bmp.Width := pic.Width ;
    bmp.Height := pic.Height ;
    bmp.Canvas.Draw (0, 0, pic.Graphic);
    PixTwix.SetSecondaryPictureHandle (bmp.Handle);
  finally
    pic.Free ;
    bmp.Free ;
  end;
  If PixTwix.Texture(0, tmStretched, True) Then UpdateDisplay;
end;

procedure TForm1.Selectusingglobalmagicwandandmasknotselected1Click(
  Sender: TObject);
begin
  Display.Picture.LoadFromFile (path + 'kids.jpg');
  Prepare;
  ShowMessage(MSG_MAGICWAND);
  effect := FX_MAGICWAND;
end;

procedure TForm1.Freezoom1Click(Sender: TObject);
begin
  Prepare;
  ShowMessage(MSG_ZOOM);
  effect := FX_ZOOM;
end;

end.
